<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 07.01.14 10:13
 */

namespace VM\ApiBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use VM\ApiBundle\Entity\User;

class ChangeVMServiceUsersPasswordsCommand extends ContainerAwareCommand
{

    protected function configure()
    {
        $this
            ->setName('change:vm:service:users:passwords')
            ->setDescription("Wszystkim użytkownikom z przedrostkiem @vm.pl")
            ->addOption('password', null, InputOption::VALUE_REQUIRED, "Hasło dla wszystkich 'it'")
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $password = $input->getOption('password');

        $EntityManager = $this->getContainer()->get('doctrine')->getManager();

        $Users = $EntityManager->getRepository('VMApiBundle:User')->createQueryBuilder('u')
            ->where('u.email LIKE :email')
            ->setParameter('email', '%@vm.pl')
            ->getQuery()
            ->getResult();

        $EntityManager->getConnection()->beginTransaction();

        $password = hash('sha256', $password);
        /** @var $User User */
        foreach ($Users as $User) {
            $output->writeln($User->getEmail());
            $salt = sha1(rand(10000, 99999));
            $User->setSalt($salt);
            $User->setPassword(hash('sha512', $password . $salt));
        }

        $EntityManager->flush();
        $EntityManager->getConnection()->commit();
        $output->writeln('Zmieniono hasło użytkownikom w liczbie '.count($Users));
    }
} 